#include <reg51.h>
#include <intrins.h>
#include <font\font.h>
#include <sys\sys.h>
#include <lcd\lcd.h>

unsigned char bdata bitdata;
sbit bit7=bitdata^7;
sbit bit6=bitdata^6;
sbit bit5=bitdata^5;
sbit bit4=bitdata^4;
sbit bit3=bitdata^3;
sbit bit2=bitdata^2;
sbit bit1=bitdata^1;
sbit bit0=bitdata^0;

u16 BACK_COLOR, POINT_COLOR;   //ɫɫ	  
void LCD_Writ_Bus(char da)   //д
{	
	bitdata=da;
	LCD_SDA=bit7;LCD_SCK=0;LCD_SCK=1;
	LCD_SDA=bit6;LCD_SCK=0;LCD_SCK=1;
	LCD_SDA=bit5;LCD_SCK=0;LCD_SCK=1;
	LCD_SDA=bit4;LCD_SCK=0;LCD_SCK=1;
	LCD_SDA=bit3;LCD_SCK=0;LCD_SCK=1;
	LCD_SDA=bit2;LCD_SCK=0;LCD_SCK=1;
	LCD_SDA=bit1;LCD_SCK=0;LCD_SCK=1;
	LCD_SDA=bit0;LCD_SCK=0;LCD_SCK=1; 
} 
void LCD_WR_DATA8(char da) //-8λ
{
    LCD_AO=1;
	LCD_Writ_Bus(da);
}  
 void LCD_WR_DATA(int da)
{
    LCD_AO=1;
	LCD_Writ_Bus(da>>8);
	LCD_Writ_Bus(da);
}	  
void LCD_WR_REG(char da)	 
{
    LCD_AO=0;
	LCD_Writ_Bus(da);
}
 void LCD_WR_REG_DATA(int reg,int da)
{
    LCD_WR_REG(reg);
	LCD_WR_DATA(da);
}
void Address_set(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2)
{  
   LCD_WR_REG(0x2a);
   LCD_WR_DATA8(x1>>8);
   LCD_WR_DATA8(x1);
   LCD_WR_DATA8(x2>>8);
   LCD_WR_DATA8(x2);
  
   LCD_WR_REG(0x2b);
   LCD_WR_DATA8(y1>>8);
   LCD_WR_DATA8(y1);
   LCD_WR_DATA8(y2>>8);
   LCD_WR_DATA8(y2);

   LCD_WR_REG(0x2C);

}
void Lcd_Init(void)
{

//һЩñʱʾ
   	LCD_CS =1;
	if(LCD_CS==0)
	{
	   LCD_WR_REG_DATA(0,0);
	   LCD_ShowString(0,0," ");
	   LCD_ShowNum(0,0,0,0);
	   LCD_Show2Num(0,0,0,0);
	   LCD_DrawPoint_big(0,0);
	   LCD_DrawRectangle(0,0,0,0);
	   Draw_Circle(0,0,0);
 	 }

    LCD_REST=1;
    delayms(5);	
	LCD_REST=0;
	delayms(5);
	LCD_REST=1;
	LCD_CS=1; 
	delayms(5);
	LCD_CS =0;  //Ƭѡʹ

		LCD_WR_REG(0x11); //Sleep out
	delayms(120); //Delay 120ms
	//------------------------------------ST7735S Frame Rate-----------------------------------------//
	LCD_WR_REG(0xB1);
	LCD_WR_DATA8(0x05);


LCD_WR_REG(0x11);//Sleep exit 
delayms (120);
 
//ST7735R Frame Rate
LCD_WR_REG(0xB1); 
LCD_WR_DATA8(0x01); 

LCD_WR_DATA8(0x2C); LCD_WR_DATA8(0x2D); 
LCD_WR_REG(0xB2); 
LCD_WR_DATA8(0x01); LCD_WR_DATA8(0x2C); LCD_WR_DATA8(0x2D); 
LCD_WR_REG(0xB3); 
LCD_WR_DATA8(0x01); LCD_WR_DATA8(0x2C); LCD_WR_DATA8(0x2D); 
LCD_WR_DATA8(0x01); LCD_WR_DATA8(0x2C); LCD_WR_DATA8(0x2D); 

LCD_WR_REG(0xB4); //Column inversion 
LCD_WR_DATA8(0x07); 
 
//ST7735R Power Sequence
LCD_WR_REG(0xC0); 
LCD_WR_DATA8(0xA2); LCD_WR_DATA8(0x02); LCD_WR_DATA8(0x84); 
LCD_WR_REG(0xC1); LCD_WR_DATA8(0xC5); 
LCD_WR_REG(0xC2); 
LCD_WR_DATA8(0x0A); LCD_WR_DATA8(0x00); 
LCD_WR_REG(0xC3); 
LCD_WR_DATA8(0x8A); LCD_WR_DATA8(0x2A); 
LCD_WR_REG(0xC4); 
LCD_WR_DATA8(0x8A); LCD_WR_DATA8(0xEE); 
 
LCD_WR_REG(0xC5); //VCOM 
LCD_WR_DATA8(0x0E); 
 
LCD_WR_REG(0x36); //MX, MY, RGB mode 
LCD_WR_DATA8(0xC8); 

//ST7735R Gamma Sequence
LCD_WR_REG(0xe0); 
LCD_WR_DATA8(0x0f); LCD_WR_DATA8(0x1a); 
LCD_WR_DATA8(0x0f); LCD_WR_DATA8(0x18); 
LCD_WR_DATA8(0x2f); LCD_WR_DATA8(0x28); 
LCD_WR_DATA8(0x20); LCD_WR_DATA8(0x22); 
LCD_WR_DATA8(0x1f); LCD_WR_DATA8(0x1b); 
LCD_WR_DATA8(0x23); LCD_WR_DATA8(0x37); LCD_WR_DATA8(0x00); 

LCD_WR_DATA8(0x07); 
LCD_WR_DATA8(0x02); LCD_WR_DATA8(0x10); 
LCD_WR_REG(0xe1); 
LCD_WR_DATA8(0x0f); LCD_WR_DATA8(0x1b); 
LCD_WR_DATA8(0x0f); LCD_WR_DATA8(0x17); 
LCD_WR_DATA8(0x33); LCD_WR_DATA8(0x2c); 
LCD_WR_DATA8(0x29); LCD_WR_DATA8(0x2e); 
LCD_WR_DATA8(0x30); LCD_WR_DATA8(0x30); 
LCD_WR_DATA8(0x39); LCD_WR_DATA8(0x3f); 
LCD_WR_DATA8(0x00); LCD_WR_DATA8(0x07); 
LCD_WR_DATA8(0x03); LCD_WR_DATA8(0x10);  

LCD_WR_REG(0x2a);
LCD_WR_DATA8(0x00);LCD_WR_DATA8(0x00);
LCD_WR_DATA8(0x00);LCD_WR_DATA8(0x7f);
LCD_WR_REG(0x2b);
LCD_WR_DATA8(0x00);LCD_WR_DATA8(0x00);
LCD_WR_DATA8(0x00);LCD_WR_DATA8(0x9f);

LCD_WR_REG(0xF0); //Enable test command  
LCD_WR_DATA8(0x01); 
LCD_WR_REG(0xF6); //Disable ram power save mode 
LCD_WR_DATA8(0x00); 
 
LCD_WR_REG(0x3A); //65k mode 
LCD_WR_DATA8(0x05); 
	LCD_WR_REG(0x29); //Display on

}
//
//Color:Ҫɫ
void LCD_Clear(u16 Color)
{
	u8 VH,VL;
	u16 i,j;
	VH=Color>>8;
	VL=Color;	
	Address_set(0,0,LCD_W-1,LCD_H-1);
    for(i=0;i<LCD_W;i++)
	 {
	  for (j=0;j<LCD_H;j++)
	   	{
        	 LCD_WR_DATA8(VH);
			 LCD_WR_DATA8(VL);	

	    }

	  }
}
//ָλʾһ(32*33С)
//dcolorΪɫgbcolorΪɫ
void showhanzi(unsigned int x,unsigned int y,unsigned char index)	
{  
	unsigned char i,j;
	unsigned char *temp=hanzi;    
    Address_set(x,y,x+31,y+31); //      
	temp+=index*128;	
	for(j=0;j<128;j++)
	{
		for(i=0;i<8;i++)
		{ 		     
		 	if((*temp&(1<<i))!=0)
			{
				LCD_WR_DATA(POINT_COLOR);
			} 
			else
			{
				LCD_WR_DATA(BACK_COLOR);
			}   
		}
		temp++;
	 }
}
//
//POINT_COLOR:˵ɫ
void LCD_DrawPoint(u16 x,u16 y)
{
	Address_set(x,y,x,y);//ùλ 
	LCD_WR_DATA(POINT_COLOR); 	    
} 	 
//һ
//POINT_COLOR:˵ɫ
void LCD_DrawPoint_big(u16 x,u16 y)
{
	LCD_Fill(x-1,y-1,x+1,y+1,POINT_COLOR);
} 
//ָָɫ
//С:
//  (xend-xsta)*(yend-ysta)
void LCD_Fill(u16 xsta,u16 ysta,u16 xend,u16 yend,u16 color)
{          
	u16 i,j; 
	Address_set(xsta,ysta,xend,yend);      //ùλ 
	for(i=ysta;i<=yend;i++)
	{													   	 	
		for(j=xsta;j<=xend;j++)LCD_WR_DATA(color);//ùλ 	    
	} 					  	    
}  
//
//x1,y1:
//x2,y2:յ  
void LCD_DrawLine(u16 x1, u16 y1, u16 x2, u16 y2)
{
	u16 t; 
	int xerr=0,yerr=0,delta_x,delta_y,distance; 
	int incx,incy,uRow,uCol; 

	delta_x=x2-x1; // 
	delta_y=y2-y1; 
	uRow=x1; 
	uCol=y1; 
	if(delta_x>0)incx=1; //õ 
	else if(delta_x==0)incx=0;//ֱ 
	else {incx=-1;delta_x=-delta_x;} 
	if(delta_y>0)incy=1; 
	else if(delta_y==0)incy=0;//ˮƽ 
	else{incy=-1;delta_y=-delta_y;} 
	if( delta_x>delta_y)distance=delta_x; //ѡȡ 
	else distance=delta_y; 
	for(t=0;t<=distance+1;t++ )// 
	{  
		LCD_DrawPoint(uRow,uCol);// 
		xerr+=delta_x ; 
		yerr+=delta_y ; 
		if(xerr>distance) 
		{ 
			xerr-=distance; 
			uRow+=incx; 
		} 
		if(yerr>distance) 
		{ 
			yerr-=distance; 
			uCol+=incy; 
		} 
	}  
}    
//
void LCD_DrawRectangle(u16 x1, u16 y1, u16 x2, u16 y2)
{
	LCD_DrawLine(x1,y1,x2,y1);
	LCD_DrawLine(x1,y1,x1,y2);
	LCD_DrawLine(x1,y2,x2,y2);
	LCD_DrawLine(x2,y1,x2,y2);
}
//ָλûһָСԲ
//(x,y):ĵ
//r    :뾶
void Draw_Circle(u16 x0,u16 y0,u8 r)
{
	int a,b;
	int di;
	a=0;b=r;	  
	di=3-(r<<1);             //ж¸λõı־
	while(a<=b)
	{
		LCD_DrawPoint(x0-b,y0-a);             //3           
		LCD_DrawPoint(x0+b,y0-a);             //0           
		LCD_DrawPoint(x0-a,y0+b);             //1       
		LCD_DrawPoint(x0-b,y0-a);             //7           
		LCD_DrawPoint(x0-a,y0-b);             //2             
		LCD_DrawPoint(x0+b,y0+a);             //4               
		LCD_DrawPoint(x0+a,y0-b);             //5
		LCD_DrawPoint(x0+a,y0+b);             //6 
		LCD_DrawPoint(x0-b,y0+a);             
		a++;
		//ʹBresenham㷨Բ     
		if(di<0)di +=4*a+6;	  
		else
		{
			di+=10+4*(a-b);   
			b--;
		} 
		LCD_DrawPoint(x0+a,y0+b);
	}
} 
//ָλʾһַ

//num:Ҫʾַ:" "--->"~"
//mode:ӷʽ(1)Ƿǵӷʽ(0)
//ָλʾһַ

//num:Ҫʾַ:" "--->"~"

//mode:ӷʽ(1)Ƿǵӷʽ(0)
void LCD_ShowChar(u16 x,u16 y,u8 num,u8 mode)
{
    u8 temp;
    u8 pos,t;
	u16 x0=x;
	u16 colortemp=POINT_COLOR;      
    if(x>LCD_W-16||y>LCD_H-16)return;	    
	//ô		   
	num=num-' ';//õƫƺֵ
	Address_set(x,y,x+8-1,y+16-1);      //ùλ 
	if(!mode) //ǵӷʽ
	{
		for(pos=0;pos<16;pos++)
		{ 
			temp=asc2_1608[(u16)num*16+pos];		 //1608
			for(t=0;t<8;t++)
		    {                 
		        if(temp&0x01)POINT_COLOR=colortemp;
				else POINT_COLOR=BACK_COLOR;
				LCD_WR_DATA(POINT_COLOR);	
				temp>>=1; 
				x++;
		    }
			x=x0;
			y++;
		}	
	}else//ӷʽ
	{
		for(pos=0;pos<16;pos++)
		{
		    temp=asc2_1608[(u16)num*16+pos];		 //1608
			for(t=0;t<8;t++)
		    {                 
		        if(temp&0x01)LCD_DrawPoint(x+t,y+pos);//һ     
		        temp>>=1; 
		    }
		}
	}
	POINT_COLOR=colortemp;	    	   	 	  
}   
//m^n
u32 mypow(u8 m,u8 n)
{
	u32 result=1;	 
	while(n--)result*=m;    
	return result;
}			 
//ʾ2
//x,y :	 
//len :ֵλ
//color:ɫ
//num:ֵ(0~4294967295);	
void LCD_ShowNum(u16 x,u16 y,u32 num,u8 len)
{         	
	u8 t,temp;
	u8 enshow=0;
	num=(u16)num;
	for(t=0;t<len;t++)
	{
		temp=(num/mypow(10,len-t-1))%10;
		if(enshow==0&&t<(len-1))
		{
			if(temp==0)
			{
				LCD_ShowChar(x+8*t,y,' ',0);
				continue;
			}else enshow=1; 
		 	 
		}
	 	LCD_ShowChar(x+8*t,y,temp+48,0); 
	}
} 
//ʾ2
//x,y:
//num:ֵ(0~99);	 
void LCD_Show2Num(u16 x,u16 y,u16 num,u8 len)
{         	
	u8 t,temp;						   
	for(t=0;t<len;t++)
	{
		temp=(num/mypow(10,len-t-1))%10;
	 	LCD_ShowChar(x+8*t,y,temp+'0',0); 
	}
} 
//ʾַ
//x,y:  
//*p:ַʼַ
//16
void LCD_ShowString(u16 x,u16 y,const u8 *p)
{         
    while(*p!='\0')
    {       
        if(x>LCD_W-16){x=0;y+=16;}
        if(y>LCD_H-16){y=x=0;}
        LCD_ShowChar(x,y,*p,0);
        x+=8;
        p++;
    }  
}












